Attribute VB_Name = "Globals"
Option Explicit

Global gProject As New CProject
Global chan As Integer
Global errChan As Integer
Global X1 As Integer
Global Y1 As Integer
Global X2 As Integer
Global Y2 As Integer
Global LinesWritten As Long
Global formname As String
Global gContinuationAfterError 'flag if last line has a continuation and an error
Global gGlobalVariables 'List of global variables already dimensioned to stop dups
Global gInSub 'Are we in the middle of a subroutine? Used to check if a variable will be global.
Global duplicateRenameListCount As Integer
Global duplicateRenameList(999) As String

Function TrimAll(s As String) As String
   'trim spaces and quote signs
   s = Trim(s)
   If left(s, 1) = Chr(34) Then s = Mid(s, 2)
   If right(s, 1) = Chr(34) Then s = Mid(s, 1, Len(s) - 1)
   TrimAll = s
End Function

Function getProperty(coll As Collection, Name As String) As String
'look up property name in collection and return its value
Dim prop As CProperty

   getProperty = ""
   For Each prop In coll
      If prop.Name = Name Then
         getProperty = prop.Value
         Exit Function
      End If
   Next
   
End Function

Sub putMessage(msg As String)
   errChan = 3
   Main.fldMessages.Text = Main.fldMessages.Text & LinesWritten & " " & msg & vbCrLf
   Print #errChan, msg
   Main.fldMessages.Refresh
End Sub
Function getObjectRefs(ByVal s As String) As String
Dim objectRefs As String
Dim stopChars As String
Dim badStartChars As String
Dim ref As String
Dim p, i, j, ep1, ep2 As Integer
Dim levels As Integer 'levels of parentheses nesting
Dim quote As String
Dim s1 As String
   
   quote = Chr(34)
   If left(s, 1) = "'" Then Exit Function 'skip comments
   
   'strip out any text between quotes
   p = InStr(1, s, quote)
   Do While p > 0
      i = InStr(p + 1, s, quote)
      If i > 0 Then
         s = Mid(s, 1, p - 1) & Mid(s, i + 1)
         p = InStr(1, s, quote)
      Else
         Exit Do
      End If
   Loop
   
   'Strip same line comment from end of line
   p = InStr(1, s, " '")
   If p Then s = left(s, p - 1)
   If p Then
      p = p
   End If
   
   stopChars = "()[]{} ,"
   badStartChars = "0123456789._()$&" 'could be more
   objectRefs = ""
   p = 2
   p = InStr(Mid(s, p), ".")
   Do While p > 0
   
      'count backwards to stop character. Skip over a () expression if there is one.
      i = p - 1
      levels = 0
      Do While i > 0
         If Mid(s, i, 1) = ")" Then levels = levels + 1
         If levels = 0 And InStr(stopChars, Mid(s, i, 1)) Then Exit Do
         If Mid(s, i, 1) = "(" Then levels = levels - 1
         i = i - 1
      Loop
      
      'count forwards to stop character
      j = p + 1
      Do While j <= Len(s)
         If InStr(stopChars, Mid(s, j, 1)) Then Exit Do
         j = j + 1
      Loop
      
      ref = Mid(s, i + 1, j - 1 - i)
      
      'eliminate (expression) in the string
      ep1 = InStr(ref, "(")
      ep2 = InStr(StrReverse(ref), ")")
      If (ep1 > 0 And ep2 > 0) Then ref = left(ref, ep1 - 1) & right(ref, ep2 - 1)
         
      'check if legal object name
      If InStr(badStartChars, left(ref, 1)) Then GoTo skipThisOne:
               
      objectRefs = objectRefs & ref & " "
      
skipThisOne:
      p = InStr(j + 1, s, ".")
   Loop
   'If objectRefs <> "" Then putMessage s & vbCrLf & "objects: " & objectRefs
   
   
   getObjectRefs = Trim(objectRefs)
End Function
Function lookupProgID(progID As String) As String
'This translates the Library.Class name to ProgID
'An asterisk is put in front of ones that are not supported

   progID = LCase(progID)
   Select Case progID
      Case "ado":                               lookupProgID = "adoce.recordset.1"
      Case "cecomdlgctl.commondialog":          lookupProgID = "cecomdlg.commondialog.1"
      Case "cecommctl.comm":                    lookupProgID = "cecomm.comm.1"
      Case "ceimagelistctl.imagelist":          lookupProgID = "ceimagelist.imagelistctrl.1"
      Case "cetabstripctl.tabstrip":            lookupProgID = "cetabstrip.tabstrip.1"
      Case "commandbarbutton":                  lookupProgID = "*commandbarbutton"
      Case "commandbarcombobox":                lookupProgID = "*commandbarcombobox"
      Case "commandbarcontrols":                lookupProgID = "*commandbarcontrols"
      Case "commandbarmenubar":                 lookupProgID = "*commandbarmenubar"
      Case "filectlctl.file":                   lookupProgID = "filectl.file.1"
      Case "filectlctl.filesystem":             lookupProgID = "filectl.filesystem.1"
      Case "gridlibctl.gridctrl":               lookupProgID = "gridctrl.gridctrl.1"
      Case "imagectl.imagectl":                 lookupProgID = "Image.imagectl.1"
      Case "menu":                              lookupProgID = "*MenuControl"
      Case "menubarbutton":                     lookupProgID = "*MenuBarButton"
      Case "menubarlib.menubar":                lookupProgID = "*MenuBarLib"
      Case "menucontrols":                      lookupProgID = "*MenuControls"
      Case "mscelistviewlibctl.listviewctrl":   lookupProgID = "listviewctrl.listviewctrl.1"
      Case "mscetreeviewlibctl.treeviewctl":    lookupProgID = "treeviewctl.treeviewctl.1"
      Case "pictureboxctl.picturebox":          lookupProgID = "PictureBox.PictureBox.1"
      Case "pvbfinfunc.pvbfinfunc":             lookupProgID = "pvbfinfunc.pvbfinfunc"
      Case "winsockctl.winsock":                lookupProgID = "winsockctl.winsock.1"
      
   Case Else:                                   lookupProgID = progID
   End Select
End Function
Function getFirstWord(ByVal s As String) As String
'returns the first word of a line of code. In Basic, that will tell you what kind of statement you have
Dim p1 As Integer

   s = Trim(s)
   p1 = InStr(s, " ")
   If p1 > 0 Then getFirstWord = left(s, p1 - 1)
   If getFirstWord = "" Then getFirstWord = "'"

End Function
