Attribute VB_Name = "Export"
Sub putAllCode()
Dim Form As CForm
Dim module As CModule
   LinesWritten = 0
   gGlobalVariables = " "
   gInSub = False
   If gProject.OptionExplicit Then putCode "Option Explicit"
   If gProject.ShowOKButton Then putCode "ShowOKButton True"
   putCode "'" & gProject.Name & " Converted by evb2nsb " & App.Major & "." & App.Minor & "." & App.Revision & " on " & Date
   putCode ""
   putAdditionalControls
   putCode ""
   
   For Each Form In gProject.Forms
      Main.labStatus.Caption = "Outputting code for Form " & Form.Name
      formname = Form.Name
      makeDuplicateToRenameList Form
      putCode Form.Code
   Next
   For Each module In gProject.Modules
      Main.labStatus.Caption = "Outputting code for Module " & module.Name
      putCode "'Module " & module.Name
      putCode module.Code
   Next
   putForm_Load
End Sub

Sub putCode(Code As String)
Dim lines As Variant
Dim s As String
Dim i As Integer

   gContinuationAfterError = False
   lines = Split(Code, vbCr)
   If UBound(lines) >= 0 Then
      For i = 0 To UBound(lines)
         s = lines(i)
         Print #chan, analyzeLine(s)
         LinesWritten = LinesWritten + 1
      Next
   Else
      Print #chan, ""
   End If
End Sub
Sub putForm_Load()
Dim Form As CForm
Dim control As CControl
Dim top As Integer
Dim left As Integer
Dim width As Integer
Dim height As Integer
Dim right As Integer
Dim bottom As Integer
Dim d As Integer
Dim radius As Integer
Dim aspect As Double
Dim color As String
Dim shape As String
Dim q As String

q = Chr(34)

   
   For Each Form In gProject.Forms
      'For Each control In Form.Controls
      '   If control.ControlType = "line" Or control.ControlType = "shape" Then GoTo makeFormLoad
      'Next
      'GoTo nextForm
   
makeFormLoad:
      putCode "Sub " & Form.Name & "_Load()"
      putCode "  " & Form.Name & ".cls"
      
      For Each control In Form.Controls
         color = getProperty(control.Properties, "BorderColor")
         If color <> "" Then color = "," & color
         If control.ControlType = "line" Then
            putCode " output.DrawLine " & Val(getProperty(control.Properties, "X1")) / 15 & "," & _
                                           Val(getProperty(control.Properties, "Y1")) / 15 & "," & _
                                           Val(getProperty(control.Properties, "X2")) / 15 & "," & _
                                           Val(getProperty(control.Properties, "Y2")) / 15 & color
         End If
         
         If control.ControlType = "shape" Then
            top = Val(getProperty(control.Properties, "Top")) / 15
            left = Val(getProperty(control.Properties, "Left")) / 15
            width = Val(getProperty(control.Properties, "Width")) / 15
            height = Val(getProperty(control.Properties, "Height")) / 15
            right = left + width
            bottom = top + height
            shape = getProperty(control.Properties, "Shape")
            If shape = "" Then shape = "0"
            shape = Mid(shape, 1, 1)
     
            Select Case shape
            Case "0" 'rectangle
               putCode "  output.Drawline " & left & ", " & top & ", " & right & ", " & top & color
               putCode "  output.Drawline " & right & ", " & top & ", " & right & ", " & bottom & color
               putCode "  output.Drawline " & right & ", " & bottom & ", " & left & ", " & bottom & color
               putCode "  output.Drawline " & left & ", " & bottom & ", " & left & ", " & top & color
            Case "1" 'square
               If width < height Then d = width Else d = height
               right = left + d
               bottom = top + d
               putCode "  output.Drawline " & left & ", " & top & ", " & right & ", " & top & color
               putCode "  output.Drawline " & right & ", " & top & ", " & right & ", " & bottom & color
               putCode "  output.Drawline " & right & ", " & bottom & ", " & left & ", " & bottom & color
               putCode "  output.Drawline " & left & ", " & bottom & ", " & left & ", " & top & color
            Case "2" 'oval
               radius = width / 2
               left = left + width / 2
               top = top + height / 2
               aspect = height / width
               putCode "  output.DrawCircle " & left & "," & top & "," & radius & "," & getProperty(control.Properties, "BorderColor") & "," & aspect
            Case "3" 'circle
               If width < height Then d = width Else d = height
               radius = width / 2
               left = left + d / 2
               top = top + d / 2
               putCode "  output.DrawCircle " & left & "," & top & "," & radius & color
            Case "4" 'round rect (don't bother rounding corners)
               putCode "  output.Drawline " & left & ", " & top & ", " & right & ", " & top & color
               putCode "  output.Drawline " & right & ", " & top & ", " & right & ", " & bottom & color
               putCode "  output.Drawline " & right & ", " & bottom & ", " & left & ", " & bottom & color
               putCode "  output.Drawline " & left & ", " & bottom & ", " & left & ", " & top & color
            Case "5" 'round square (don't bother rounding corners)
               If width < height Then d = width Else d = height
               right = left + d
               bottom = top + d
               putCode "  output.Drawline " & left & ", " & top & ", " & right & ", " & top & color
               putCode "  output.Drawline " & right & ", " & top & ", " & right & ", " & bottom & color
               putCode "  output.Drawline " & right & ", " & bottom & ", " & left & ", " & bottom & color
               putCode "  output.Drawline " & left & ", " & bottom & ", " & left & ", " & top & color
            End Select
         End If
      Next
      
      putCode "  callIfExists(" & q & Form.Name & "_Load_Startup" & q & ")" 'run startup code for the form"
      putCode "  callIfExists(" & q & Form.Name & "_Load_User" & q & ")"   'run the user's form_load code"
      putCode "End Sub" & vbCr
nextForm:
   Next
   
End Sub
Sub putAllForms()
Dim Form As CForm
   putCode vbCr & vbCr & "'*** Begin Generated Code ***" & vbCr
   putAppStuff
   putCode TrimAll(getProperty(gProject.Properties, "Startup")) & "_Show 'Default Form" & vbCr
   
   For Each Form In gProject.Forms
      Main.labStatus.Caption = "Outputting Form objects for " & Form.Name
      makeDuplicateToRenameList Form
      putForm Form
   Next
   
   putCode "  Sub CallIfExists(theSub)"
   putCode "    Dim s"
   putCode "    On Error Resume Next"
   putCode "    Set s = GetRef(theSub)"
   putCode "    If Err.Number <> 0 Then Exit Sub 'it does not exist"
   putCode "    On Error GoTo 0"
   putCode "    Execute (theSub) 'execute it"
   putCode "  End Sub"
   putCode "  "
   
   putCode vbCr & "'*** End Generated Code ***"
   
End Sub
Sub putForm(Form As CForm)
Dim control As CControl
Dim q As String

   q = Chr(34)
   putCode "Dim " & Form.Name & "_Temp"
   putCode "Sub " & Form.Name & "_Show"
   'putCode Form.Name & "_ShowMenu"
   putCode "   On Error Resume Next" & vbCr
   putCode "   UpdateScreen" & vbCr
   
   'output controls
   putCode "   If IsEmpty(" & Form.Name & "_Temp) Then"
   putCode "      AddObject " & q & "Frame" & q & ", " & q & Form.Name & "_Form" & q & ", 0, 0, Output.Width, Output.Height"
   putCode "      " & Form.Name & "_Form.Visible = False"
   putCode "      " & Form.Name & "_Form.BackColor = " & getProperty(Form.Properties, "BackColor")
   putCode "      AddObject " & q & "PictureBox" & q & ", " & q & Form.Name & q & ", 0, 0, 0, 0, " & Form.Name & "_Form"
   putCode "      " & Form.Name & ".BorderStyle = 0"
   putCode "      " & Form.Name & ".Move 0, 0, " & Form.Name & "_Form.Width * 15, " & Form.Name & "_Form.Height * 15"
   putCode "      Set " & Form.Name & "_Temp = " & Form.Name 'should _Temp be _Form?
   putCode "      " & Form.Name & "_Temp.Caption = " & q & Form.Name & q
         
   'output Form Object properties
   For Each property In Form.Properties
      If left(property.Name, 6) <> "Client" And left(property.Name, 3) <> "VB_" Then
      
         'don't output certain settings at Form level
         If InStr("Name|Size|Charset|Weight|Underline|Italic|StrikeThrough|ScaleHeight|ScaleWidth", property.Name) = 0 Then
            putCode "      " & Form.Name & "." & property.Name & " = " & property.Value
         End If
         
      End If
   Next
   putCode ""
   
   'For i = Form.Controls.Count To 1 Step -1
   '    Set control = Form.Controls(i)
   '    If control.ControlType <> "Line" And control.ControlType <> "Shape" Then
   '      putControl control, Form.Name
   '    End If
   'Next
   formname = Form.Name
   putChildControls Form, Form.Name
   
   putCode "   End If"
   putCode "   " & Form.Name & "_Form" & ".Visible = True"
   putCode "   " & Form.Name & "_Load"
   putCode "   CallIfExists(" & q & Form.Name & "_Load" & q & ")"
   putCode "End Sub '" & Form.Name & "_Show" & vbCr
   putCode ""
   
   putCode "Sub " & Form.Name & "_Hide"
   putCode "   If IsEmpty(" & Form.Name & "_Temp) Then"
   putCode "      Err.Raise 44000, , " & q & "Form not loaded" & q
   putCode "      Exit Sub"
   putCode "   End If"
   putCode ""
   putCode "   On Error Resume Next"
   putCode "   " & Form.Name & "_From.Visible = False"
   putCode "   CallIfExists(" & q & Form.Name & "_Unload" & q & ")"
   putCode "End Sub '" & Form.Name & "_Hide" & vbCr
   
   'put menucode here if there is a menu
   putCode "'Sub " & Form.Name & "ShowMenu"
   putCode "   'SetMenu..."
   putCode "'End Sub '" & Form.Name & "_ShowMenu" & vbCr
   
End Sub
Sub putChildControls(Form As CForm, frame As String)
'This sub is recursive. It creates the controls for a frame, and calls itself to create the children control
Dim i As Integer
Dim control As CControl

   For i = Form.Controls.Count To 1 Step -1
       Set control = Form.Controls(i)
       If getProperty(control.Properties, "ParentHWnd") = frame Then
          putControl control
          putChildControls Form, control.Name
       End If
   Next
   
End Sub
Sub putControl(control As CControl)
Dim q As String
Dim bounds As String
Dim top, left, height, width As Integer
Dim ControlType As String
Dim controlName As String
Dim property As CProperty
Dim comment As String

   q = Chr(34)
             
   'control type
   ControlType = control.ControlType
   If InStr(" shape commandbar timer line ", ControlType) Then
      ControlType = "PictureBox" 'use the closest we've got
      putCode "      '* PictureBox used as substitute for " & control.ControlType & " control."
   End If
   
   comment = "  "
   If Mid(ControlType, 1, 1) = "*" Then
      comment = "'*"
      ControlType = Mid(ControlType, 2)
   End If
   
   'get bounds
   top = Val(getProperty(control.Properties, "Top")) / 15
   left = Val(getProperty(control.Properties, "Left")) / 15
   height = Val(getProperty(control.Properties, "Height")) / 15
   width = Val(getProperty(control.Properties, "Width")) / 15
   bounds = ", " & left & ", " & top & ", " & width & ", " & height
   
   If control.Duplicate = False Then
      contName = control.Name
   Else
      contName = formname & "_" & control.Name
   End If
   
   putCode comment & "    AddObject " & q & ControlType & q & ", " & q & contName & q & bounds & ", " & getProperty(control.Properties, "ParentHWnd")
      
   For Each property In control.Properties
      If InStr(" Top Left Width Height _cx _cy Container ParentHWnd List ItemData ", " " & property.Name & " ") Then GoTo skipProperty
      If Mid(property.Name, 1, 1) = "_" Then GoTo skipProperty
      putCode "      " & control.Name & "." & property.Name & " = " & property.Value
skipProperty:
   Next
     
   putCode "      '--------"
   
End Sub
Function analyzeLine(s As String)
Dim objectRefs As Variant
Dim ControlType As String
Dim i, p As Integer
Dim firstWord As String

   'is the line a comment?
   If left(Trim(s), 1) = "'" Then GoTo returnValue

   'is the line a continuation of a line that had an error?
   If gContinuationAfterError Then
      s = "'* " & s
      If right(s, 1) <> "_" Then gContinuationAfterError = False
      GoTo returnValue
   End If
   
   'General stuff
   firstWord = getFirstWord(s)
   If InStr(" Public Private ", " " & firstWord & " ") > 0 Then 'get rid of Public|Private, since they do not do anything in VBScript
      s = fixPublicPrivate(s)
      firstWord = getFirstWord(s) 'need to get first word again, since we trimmed the old one off
   End If
      
   If firstWord = "Declare" Then s = fixDeclare(s)
   If firstWord = "Const" Then s = fixConst(s)
   If InStr("Dim Sub Function ", firstWord & " ") Then s = fixAsClause(s)
   If InStr("Dim Const ", firstWord & " ") And Not gInSub Then s = fixDim(s)
   If InStr("Sub Function ", firstWord & " ") Then gInSub = True
   If InStr(s, "End Sub") Or InStr(s, "End Function") Then gInSub = False
   If firstWord = "Sub" And InStr(s, "Sub Form_") Then s = fixFormEvents(s)
   If firstWord = "Next" Then s = fixNext(s)
   If InStr("#", s) Then s = fixHashedConstant(s)
   
   objectRefs = Split(getObjectRefs(s))
   If UBound(objectRefs) >= 0 Then
      For i = 0 To UBound(objectRefs)
          ControlType = getControlType(CStr(objectRefs(i)))
          If left(ControlType, 1) = "*" Then ControlType = Mid(ControlType, 2)
          s = fixObjectRef(ControlType, s, CStr(objectRefs(i)))
          If InStr(s, ".ZOrder") Then s = fixZOrder(s)
      Next
   End If
   
   'Look for .frx": statements
   p = InStr(s, ".frx" & Chr(34) & ":")
   If p Then
      s = left(s, p + 4) & "'" & Mid(s, p + 5) & "  'NSB: Extract resource and do in code."
      s = Replace(s, " $" & Chr(34), " " & Chr(34)) 'replace  $" with simply ".
      putMessage Trim(s) & " Reference to .frx file. Extract resource and do in code."
      
      p = 0
   End If
   
   'rename duplicate control names
   For i = 1 To duplicateRenameListCount
      s = Replace(s, duplicateRenameList(i) & ".", formname & "_" & duplicateRenameList(i) & ".")
      s = Replace(s, "Sub " & duplicateRenameList(i) & "_", "Sub " & formname & "_" & duplicateRenameList(i) & "_")
   Next
      
returnValue:
   analyzeLine = s
End Function
Function getControlType(Name As String) As String
Dim object As CObject
Dim objectName As String
Dim Form As CForm

   'if an intrinsic or ActiveX control that is in the project, return the ControlType
   'if an object, return the object name
   objectName = Mid(Name, 1, InStr(Name, ".") - 1)
   For Each object In gProject.Objects
      If object.Name = objectName Then
         getControlType = object.ControlType
         Exit Function
      End If
   Next
   
   'if it is a form, return "Form"
   For Each Form In gProject.Forms
      If Form.Name = objectName Then
         getControlType = "Form"
         Exit Function
      End If
   Next
         
   getControlType = objectName
End Function
Sub putAppStuff()
Dim q As String
   If gProject.App <> True Then Exit Sub 'skip this if project does not use App object
   
   q = Chr(34)
   s = getProperty(gProject.Properties, "VersionComments")
   If s <> "" Then putCode "Dim AppComments: AppComments = " & s
   s = getProperty(gProject.Properties, "VersionCompanyName")
   If s <> "" Then putCode "Dim AppCompanyName: AppCompanyName = " & s
   s = q & gProject.Name & q
   If s <> "" Then putCode "Dim AppEXEName: AppEXEName = " & s
   s = getProperty(gProject.Properties, "VersionFileDescription")
   If s <> "" Then putCode "Dim AppFileDescription: AppFileDescription = " & s
   s = getProperty(gProject.Properties, "VersionLegalCopyright")
   If s <> "" Then putCode "Dim AppLegalCopyright: AppLegalCopyright = " & s
   s = getProperty(gProject.Properties, "VersionLegalTrademarks")
   If s <> "" Then putCode "Dim AppLegalTradeMarks: AppLegalTradeMarks = " & s
   s = getProperty(gProject.Properties, "MajorVer")
   If s <> "" Then putCode "Dim AppMajor: AppMajor = " & s
   s = getProperty(gProject.Properties, "MinorVer")
   If s <> "" Then putCode "Dim AppMinor: AppMinor = " & s
   s = getProperty(gProject.Properties, "RemotePath")
   If s <> "" Then putCode "Dim AppPath: AppPath = " & q & s & q
   s = getProperty(gProject.Properties, "VersionProductName")
   If s <> "" Then putCode "Dim AppProductName: AppProductName = " & s
   s = getProperty(gProject.Properties, "RevisionVer")
   If s <> "" Then putCode "Dim AppRevision: AppRevision = " & s
   's = getProperty(gProject.Properties, "?")
   'If s <> "" Then putCode "Dim AppTaskVisible: AppTaskVisible = " & s
   s = getProperty(gProject.Properties, "Title")
   If s <> "" Then putCode "Dim AppTitle: AppTitle = " & s
   putCode ""
End Sub
Sub putAdditionalControls()
'If additional controls are needed, they are added here
Dim q As String
Dim s As String
Dim object As CObject

   q = Chr(34)
   'Is there an object that needs the API control?
   If gProject.Clipboard Then
      s = "addObject " & q & "MGCEWin32.API" & q & "," & q & "API" & q & vbTab & "'NSB Added"
      putCode s
      putMessage s
   End If
      
End Sub

Sub makeDuplicateToRenameList(Form As CForm)
   Dim control As CControl
   duplicateRenameListCount = 0
   For Each control In Form.Controls
      If control.Duplicate Then
         duplicateRenameListCount = duplicateRenameListCount + 1
         duplicateRenameList(duplicateRenameListCount) = control.Name
      End If
   Next
End Sub

Function fixObjectRef(ControlType As String, s As String, objectRef As String)
Dim ep1, ep2 As Integer
Dim newObjectRef As String
Dim formname As String

   ep1 = InStr(objectRef, ".")
   ep2 = InStr(ep1 + 1, objectRef, ".")
   newObjectRef = ""
   If ep2 > 0 Then 'if the objectRef is form.object.property, change it to object.property
      formname = left(objectRef, ep1 - 1)
      For Each Form In gProject.Forms
         If formname = Form.Name Then newObjectRef = Mid(objectRef, ep1 + 1)
      Next
      If newObjectRef <> "" Then
         s = Replace(s, objectRef, newObjectRef)
         objectRef = newObjectRef
         ControlType = getControlType(objectRef)
      End If
   End If
   
selectCase:
   Select Case ControlType
   'Intrinsic Controls
   Case "CheckBox":        pass
   Case "ComboBox":        s = fixCombobox(s, objectRef)
   Case "CommandButton":   pass
   Case "Frame":           pass 's = fixFrame(s)
   Case "HScrollBar":      pass
   Case "Label":           pass
   Case "Line":            s = fixFrame(s)
   Case "ListBox":         s = fixListBox(s, objectRef)
   Case "OptionButton":    pass
   Case "Shape":           s = fixShape(s)
   Case "TextBox":         pass
   Case "Timer":           s = fixTimer(s)
   Case "VScrollBar":      pass
   Case "Me":              s = notSupported(s, ControlType)
  
   'Known ActiveX Controls
   Case "Comm":                    pass
   Case "Dialog":                  pass
   Case "File":                    pass
   Case "FileSystem":              pass
   Case "Finance":                 pass
   Case "Grid":                    pass
   Case "Image":                   pass
   Case "ImageList":               pass
   Case "ListView":                pass
   Case "Menu":                    s = notSupported(s, ControlType)
   Case "MenuBarLib":              s = notSupported(s, ControlType)
   Case "PictureBox":              pass
   Case "TabStrip":                pass
   Case "TreeView":                pass
   Case "WinSock":                 pass
   
   'standard objects (some of these won't appear, since they are part of other controls)
   Case "App":             s = fixApp(s, objectRef)
   Case "MenuBarButton":   s = notSupported(s, ControlType)
   Case "Clipboard":       s = fixClipboard(s, objectRef)
   Case "ColumnHeader":    pass
   Case "ColumnHeaders":   pass
   Case "CommandBarButton": s = notSupported(s, ControlType)
   Case "CommandBarComboBox": s = notSupported(s, ControlType)
   Case "CommandBarControls": s = notSupported(s, ControlType)
   Case "CommandBarMenuBar": s = notSupported(s, ControlType)
   Case "Err":             pass
   Case "Font":            pass
   Case "Form":            s = fixForm(s, objectRef)
   'Case "Item":            s = notSupported(s, ControlType) 'this one is sometimes OK
   Case "Items":           s = notSupported(s, ControlType)
   Case "ListItem":        pass
   Case "ListItems":       pass
   Case "Menu":            s = notSupported(s, ControlType)
   Case "MenuControl":     s = notSupported(s, ControlType)
   Case "MenuControls":    s = notSupported(s, ControlType)
   Case "Node":            pass
   Case "nodes":           pass
   Case "Screen":          s = fixScreen(s, objectRef)
   Case "Tab":             pass
   Case "Tabs":            pass
   
   'all others
   Case Else:
   End Select
   
ExitSub:
   fixObjectRef = s
End Function
