Attribute VB_Name = "Exceptions"
Sub pass() 'do nothing
End Sub
Function notSupported(s As String, ControlType As String) As String
   notSupported = "'*" & s & vbTab & "'NSB: " & ControlType & " not supported."
   putMessage notSupported
End Function
Function fixCombobox(s As String, objectRef As String)
Dim p As Integer
Dim s1 As String
Dim s2 As String
   
   p = InStr(objectRef, ".")
   s1 = Mid(objectRef, p + 1)
   Select Case s1
      Case "List", "ItemData":   s = notSupported(s, objectRef)
      Case Else:                 pass
   End Select
   
   fixCombobox = s
End Function
Function fixFrame(s As String) As String
   fixFrame = "'*  " & s & vbTab & "'NSB: Frame Control not supported"
   putMessage fixFrame
End Function
Function fixLine(s As String) As String
   fixLine = "" 'drop these
End Function
Function fixListBox(s As String, objectRef As String)
Dim p As Integer
Dim s1 As String
Dim s2 As String
   
   p = InStr(objectRef, ".")
   s1 = Mid(objectRef, p + 1)
   Select Case s1
      Case "List", "ItemData":   s = notSupported(s, objectRef)
      Case Else:                 pass
   End Select
   
   fixListBox = s
End Function
Function fixShape(s As String) As String
   fixShape = "" 'drop these
End Function
Function fixTimer(s As String) As String
   fixTimer = "'*  " & s & vbTab & "'NSB: Timer Control not supported. Use S309Timer instead."
   putMessage fixTimer
End Function
Function fixMenuBar(s As String) As String
   'have to figure out how eVB menus work and translate to SetMenu
   fixMenuBar = "'*  " & s & vbTab & "'NSB: MenuBar not supported."
   putMessage fixMenuBar
End Function
Function fixApp(s As String, objectRef As String)
Dim p As Integer
Dim s1 As String
Dim s2 As String
   
   p = InStr(objectRef, ".")
   s1 = Mid(objectRef, p + 1)
   Select Case s1
      Case "Comments", "CompanyName", "EXEName", "FileDescription", "LegalCopyright", _
      "LegalTrademarks", "Major", "Minor", "Path", "ProductName", "Revision", "TaskVisible", _
      "Title"
         s2 = left(objectRef, p - 1) & s1 'Change App.property to AppProperty
         s = Replace(s, objectRef, s2)
      Case "End":
         s = Replace(s, objectRef, "Bye 'was App.End")
      Case Else:     s = notSupported(s, objectRef) 'includes EndWaitForEvents and WaitForEvents
   End Select
   
   fixApp = s
End Function
Function fixClipboard(s As String, objectRef)
Dim p As Integer
Dim s1 As String
Dim s2 As String
Dim quote As String
   
   quote = Chr(34)
   p = InStr(objectRef, ".")
   s1 = Mid(objectRef, p + 1)
   Select Case s1
      Case "Clear"
         s = Replace(s, objectRef, "API.ClipText = " & quote & quote)
      Case "GetFormat"
         s = Replace(s, objectRef, "13") '13 (=vbCFText) is only legal value
      Case "GetText"
         s = Replace(s, objectRef, "API.ClipText")
      Case "SetText"
         s = Replace(s, objectRef, "API.ClipText")
   End Select
   
   fixClipboard = s
End Function
Function fixForm(s As String, objectRef As String)
   Dim s1 As String
   quote = Chr(34)
   p = InStr(objectRef, ".")
   s1 = Mid(objectRef, p + 1)
   Select Case s1
      '------------------ Properties
      Case "ActiveControl":      s = notSupported(s, objectRef)
      Case "Appearance":         pass 's = notSupported(s, objectRef)
      Case "AutoRedraw":         s = notSupported(s, objectRef)
      Case "BackColor":          pass
      Case "BorderStyle":        pass
      Case "Caption":            s = Replace(s, objectRef, "AppTitle")
      Case "ClipControls":       s = notSupported(s, objectRef)
      Case "Controls":           s = notSupported(s, objectRef)
      Case "CurrentX":           s = notSupported(s, objectRef)
      Case "CurrentY":           s = notSupported(s, objectRef)
      Case "DrawMode":           pass
      Case "DrawStyle":          pass
      Case "DrawWidth":          pass
      Case "Enabled":            s = notSupported(s, objectRef)
      Case "FillColor":          pass
      Case "FillStyle":          pass
      Case "Font":               pass
      Case "FontBold":           pass
      Case "FontItalic":         pass
      Case "FontName":           pass
      Case "FontSize":           pass
      Case "Fonts":              pass
      Case "FontStrikethru":     pass
      Case "FontTransparent":    pass
      Case "FontUnderline":      pass
      Case "ForeColor":          pass
      Case "FormResize":         s = notSupported(s, objectRef)
      Case "HDC":                s = notSupported(s, objectRef)
      Case "Height":             pass
      Case "HWnd":               pass
      Case "KeyPreview":
         s = Replace(s, objectRef, "KeyPreview")
      Case "Left":               pass
      Case "Moveable":           s = notSupported(s, objectRef)
      Case "Name":               s = notSupported(s, objectRef)
      Case "ScaleHeight":        pass
      Case "ScaleLeft":          pass
      Case "ScaleTop":           pass
      Case "ScaleWidth":         pass
      Case "ShowInTaskBar":      s = notSupported(s, objectRef)
      Case "ShowOK":
         gProject.ShowOKButton = True
      Case "SIPBehavior":        s = notSupported(s, objectRef)
      Case "SIPVisible"
         s = Replace(s, objectRef, "Keyboardmain.labstatus")
      Case "Tag":                pass
      Case "Top":                pass
      Case "Visible":            s = notSupported(s, objectRef)
      Case "Width":              pass
      Case "WindowState":        s = notSupported(s, objectRef)

      '----------------- Methods
      Case "Cls":                pass
      Case "DrawCircle":         pass
      Case "DrawLine":           pass 'need to change the order of the arguments!
      Case "Hide"
         s1 = Replace(objectRef, ".", "_")
         s = Replace(s, objectRef, s1) 'replace frmXXX.Hide with frmXXX_Hide
      Case "Move":               pass
      Case "Point":              s = notSupported(s, objectRef)
      Case "PointSet":           s = notSupported(s, objectRef)
      Case "Refresh":            pass
      Case "SetScale":           pass
      Case "ScaleX":             pass
      Case "ScaleY":             pass
      Case "SetFocus":           pass
      Case "Show":
         s1 = Replace(objectRef, ".", "_")
         s = Replace(s, objectRef, s1) 'replace frmXXX.Show with frmXXX_Show
      Case "TextHeight":         pass
      Case "TextWidth":          pass
      Case "ZOrder":
         s = notSupported(s, objectRef)

      '----------------- Events
      Case "Activate":           s = notSupported(s, objectRef)
      Case "Click":              pass
      Case "DblClick":           pass
      Case "Deactivate":         s = notSupported(s, objectRef)
      Case "GotFocus":           pass
      Case "KeyDown":            pass
      Case "KeyPress":           pass
      Case "KeyUp":              pass
      Case "Load":               s = notSupported(s, objectRef)
      Case "LostFocus":          pass
      Case "MouseDown":          pass
      Case "MouseMove":          pass
      Case "MouseUp":            pass
      Case "OKClick":            s = notSupported(s, objectRef)
      Case "Paint":              s = notSupported(s, objectRef)
      Case "QueryUnload":        s = notSupported(s, objectRef)
      Case "Resize":             pass
      Case "SIPChange":
         s = Replace(s, objectRef, "KeyBoardmain.labstatusChanged")
      Case "Terminate":          s = notSupported(s, objectRef)
      Case Else:                 s = notSupported(s, objectRef)
   End Select
   
   fixForm = s
End Function
Function fixScreen(s As String, objectRef As String)
Dim p As Integer
Dim s1 As String
Dim s2 As String
Dim quote As String
   
   quote = Chr(34)
   p = InStr(objectRef, ".")
   s1 = Mid(objectRef, p + 1)
   Select Case s1
      Case "ActiveControl":      s = notSupported(s, objectRef)
      Case "ActiveForm":         s = notSupported(s, objectRef)
      Case "FontCount":          s = notSupported(s, objectRef)
      Case "Fonts":              s = notSupported(s, objectRef)
      Case "Height"
         s = Replace(s, objectRef, "Output.Height")
      Case "TwipsPerPixelX"
         s = Replace(s, objectRef, "15   'NSB: This seems to be the standard value.")
      Case "TwipsPerPixelY"
         s = Replace(s, objectRef, "15   'NSB: This seems to be the standard value.")
      Case "Width"
         s = Replace(s, objectRef, "Output.Width")
   End Select
   fixScreen = s
End Function
Function fixDeclare(s As String) As String
Dim comment As String
Dim p1 As Integer

   'evb: Declare Function RegCloseKey Lib "Coredll" (ByVal hKey As Long) As Long
   'nsb: Declare "Function RegCloseKey Lib ""Coredll"" (ByVal hKey As Long) As Long"
   
   p1 = InStr(s, " '") 'get start of inline comment. This won't work on " 'test", but this is not likely in a Declare
   If p1 Then
      comment = Mid(s, p1)
      s = Trim(left(s, p1 - 1))
   End If
   
   s = Replace(s, Chr(34), Chr(34) & Chr(34))
   fixDeclare = Replace(s, "Declare ", "Declare " & Chr(34)) & Chr(34) & comment
End Function
Function fixAsClause(s)
'As varType not needed - all variables are variants - so get rid of it.
Dim p1 As Integer
Dim p2 As Integer
Dim p3 As Integer
Do While InStr(s, " As ") > 0
   p1 = InStr(s, " As ")
   'find next character after varType
   p2 = p1 + 4
   
   'p3 = InStr(Mid(s, p1 + 4), ")")
   'If p2 = 0 Then p2 = p3
   'If p3 > 0 And p3 < p2 Then p2 = p3
   '
   'p4 = InStr(Mid(s, p1 + 4), ",")
   'If p2 = 0 Then p2 = p4
   'If p4 > 0 And p4 < p2 Then p2 = p4
   
   Do While p2 <= Len(s)
      If Mid(s, p2, 1) = ":" Then Exit Do 'another statement on same line
      If Mid(s, p2, 1) = "'" Then Exit Do 'comment on same line
      If Mid(s, p2, 1) = "," Then Exit Do 'another argument on same line
      If Mid(s, p2, 1) = " " Then Exit Do 'more stuff on same line
      If Mid(s, p2, 1) = ")" Then Exit Do 'more stuff on same line
      If Mid(s, p2, 1) = "(" Then 'skip past subscript expression
         Do While Mid(s, p2, 1) <> ")" And p2 <= Len(s)
            p2 = p2 + 1
         Loop
      End If
      p2 = p2 + 1
   Loop
   If p2 > Len(s) Then p2 = 0
   
   If p2 = 0 Then
      s = left(s, p1 - 1)
   Else
      s = left(s, p1 - 1) & Mid(s, p2)
   End If
Loop
fixAsClause = s
End Function
Function fixNext(s)
'VB allows argument after Next, NSB does not. Put a comment ' in front of the argument
Dim p1 As Integer

   p1 = InStr(s, "Next ")
   If p1 > 0 Then
      s = left(s, p1 + 4) & "'" & Mid(s, p1 + 5)
   End If
   fixNext = s
End Function
Function fixPublicPrivate(ByVal s As String)
'Public and Private don't do anything, so they get removed
Dim firstWord

   firstWord = getFirstWord(s)
   If firstWord = "Public" Then s = Mid(s, InStr(s, "Public") + 7) 'Public and Private don't do anything in VBScript
   If firstWord = "Private" Then s = Mid(s, InStr(s, "Private") + 8)
   firstWord = getFirstWord(s)
   If InStr(" Sub Function Declare Const ", " " & firstWord & " ") = 0 Then
      s = "Dim " & s
   End If
   fixPublicPrivate = s

End Function
Function fixFormEvents(ByVal s As String)
'Form event names are uniquely named to the form's name in NSB
'The user's form load event is called formName_Load_User
   s = Replace(s, "Sub Form_", "Sub " & formname & "_")
   s = Replace(s, formname & "_Load", formname & "_Load_User")
   fixFormEvents = s
End Function
Function fixConst(ByVal s As String)
   'Const A=0 becomes Dim A: A = 0
   Dim p, p1 As Integer
   p = InStr(s, "Const")
   p1 = InStr(Mid(s, p + 6), " ") 'end of variable name
   s = "Dim " & left(s, p - 1) & Mid(s, p + 6, p1 - 1) & ": " & Mid(s, p + 6)
   fixConst = s
End Function
Function fixHashedConstant(ByVal s As String)
   '...N# becomes ...N
   Dim p, p1 As Integer
   p = InStr(s, "#")
   Do While p > 1
      If Mid(s, p - 1, 1) >= 0 And Mid(s, p - 1, 1) <= 9 Then s = left(s, p - 1) & Mid(s, p + 1)
      p = InStr(p + 1, s, "#")
   Loop
   fixHashedConstant = s
End Function
Function fixDim(ByVal s As String) As String
Dim a As Variant

   a = Split(s)
   For i = 1 To UBound(a)
      If a(i) = "" Then GoTo nexti
      If InStr("Dim Constant ", a(i) & " ") Then GoTo nexti
      If InStr("0123456789", left(a(i), 1)) Then GoTo nexti 'skip if part of a multiple array size def
      If InStr(a(i), "(") Then a(i) = left(a(i), InStr(a(i), "(") - 1) 'trim off array size, if any
      If right(a(i), 1) = "," Then a(i) = left(a(i), Len(a(i)) - 1) 'multiple variable will have commas after them
      If right(a(i), 1) = ":" Then 'colon if another statement on line
         a(i) = left(a(i), Len(a(i)) - 1)
         If i + 1 <= UBound(a) Then a(i + 1) = "'" 'make the next token a comment so processing ends
      End If
      If left(a(i), 1) = "'" Then Exit For 'comment - skip rest of line
      If InStr(gGlobalVariables, " " & a(i) & " ") Then
         fixDim = "'*" & s & vbTab & "'NSB: Already Defined."
         putMessage fixDim
         If a(i) = "CheckText" Then
            i = i
         End If
      Else
         gGlobalVariables = gGlobalVariables & a(i) & " "
         fixDim = s
      End If
nexti:
   Next
End Function
Function fixZOrder(s As String) As String
   fixZOrder = "'*  " & s & vbTab & "'NSB: .ZOrder not supported"
   putMessage fixZOrder
End Function
