'********************************************************************************************************************************
'***  
'***	23.01.08 Poor Man's Progressbar ML
'***
'********************************************************************************************************************************
Dim GPB1, GPB2

Public Sub PBar_Hide
   GPB1.Visible = False
   GPB2.Visible = GPB1.Visible
End Sub

Public Sub PBar_Init(ByVal Left, ByVal Top, ByVal Width, ByVal Height,ByRef Parent)
   AddObject "Label", "GPB1", Left, Top, Width, Height, Parent
   GPB1.Visible     = False
   GPB1.BorderStyle = 1
   AddObject "Label", "GPB2", Left+1, Top+1, Width-2, Height-1, Parent
   GPB2.Visible     = GPB1.Visible
   GPB2.BackColor   = vbBlue
   GPB2.ForeColor   = vbWhite
End Sub

Public Sub PBar_Progress(ByVal Percent, ByVal txt)
   If GPB1.Visible = False Then Call PBar_Show
   If txt = "" Then
      GPB2.Caption   = Percent & "%"
   Else
      GPB2.Caption = txt
   End If
   GPB2.Width = (GPB1.Width - 2) * Percent / 100
   'very strange, this has to be done when WS_BORDER is active
   'if not the Label will walk out of the box downwards
   'Demo: you can watch this when you Check "BORDER" without "DLGFRAME"
   If (Style And WS_CAPTION) = WS_CAPTION Then
      GPB2.Left = GPB1.Left-1
      GPB2.Top = GPB1.Top-24
   End If
End Sub

Public Sub PBar_Show
   GPB1.Visible = True
   GPB2.Width   = 0
   GPB2.Visible = GPB1.Visible
   GPB2.Left    = GPB1.Left + 1
   GPB2.Top     = GPB1.Top + 1
End Sub
