// TabEdit.cpp : implementation file
//

#include "stdafx.h"
#include "script.h"
#include "TabEdit.h"

#undef _DEBUG // EMP DIKEO

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CTabEdit

CTabEdit::CTabEdit()
{
}

CTabEdit::~CTabEdit()
{
}


BEGIN_MESSAGE_MAP(CTabEdit, CEdit)
	//{{AFX_MSG_MAP(CTabEdit)
	ON_WM_CHAR()
	ON_WM_KEYDOWN()
		// NOTE - the ClassWizard will add and remove mapping macros here.
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTabEdit message handlers
void CTabEdit::OnChar(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	switch (nChar)
	{
	case VK_TAB:
		if(GetAsyncKeyState(VK_SHIFT))
			ReplaceSel( TEXT("\t") );
		else
			ReplaceSel( kTabString );
		return;
	case VK_RETURN:
		{
			// Get the number of tabs starting this line, and 
			// start the next line with the same number
			int first,last;
			int iLine;
			int iLength;
			TCHAR sz[256];

			GetSel(first,last);
			iLine=LineFromChar(first);
			iLength=LineLength(first);
			if (iLength > 255)
				break;
			GetLine( iLine, sz, 255 );
			sz[iLength] = '\0';
			
			/*{
				TCHAR szChar[60];
				wsprintf(szChar,L"%i %i %i (%i) '%s'",first,last,iLine,iLength,sz);
				MessageBox(szChar,L"",MB_OK);
			}*/


			CEdit::OnChar(nChar, nRepCnt, nFlags);
			for (int i = 0;  sz[i]==L' ' || sz[i]==L'\t'; i++);
				//do nothing
			//truncate the string - we want only the whitespace at the front..
			sz[i]=0;
			ReplaceSel(sz);
			return;
		}
	default:
		break;
	}
	CEdit::OnChar(nChar, nRepCnt, nFlags);
}

void CTabEdit::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	// just swallow a tab character, so the control does not lose focus
	if (nChar == VK_TAB)
		return;
	else
		CEdit::OnKeyDown(nChar, nRepCnt, nFlags);
}
