// OutputWindow.cpp : implementation file
//

#include "stdafx.h"
#include "script.h"
#include "OutputWindow.h"
#include "MainFrm.h"
#include "sipapi.h"
#include "FullScreen.h"

#undef _DEBUG // EMP DIKEO

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern COutputWindow *gpOutputWindow;
extern BOOL gbScriptRunning;
extern BOOL gbQuitting;
extern bool gbEnterModalLoop;
extern LaunchModeType gLaunchMode;

extern bool gbShowEditorWindow;	//Is the main window shown?
extern bool gbAllowEmptyLaunch;	//Can the app be launched without a file?
extern bool gbCloseOnEnd;		//Does entire app close when program exits?
extern bool gbAllowSave;			//Can apps be saved?


CMenuObject::CMenuObject() {hmenuParent=0; hMenu=0; iID=0; dwFlags=0;};
CMenuObject::~CMenuObject() {};

/////////////////////////////////////////////////////////////////////////////
// COutputWindow

IMPLEMENT_DYNCREATE(COutputWindow, CFrameWnd)

COutputWindow::COutputWindow()
{
	EnableAutomation();
	gbScriptRunning=false;
	m_menus.RemoveAll();
	m_menuIDMap.RemoveAll();
	m_bKeyPreview=false;
	m_bOKButton=false;
	pEngine = NULL;
}

COutputWindow::~COutputWindow()
{
	//release all of our menu lookup table info...
	POSITION pos = m_menus.GetStartPosition();
	while( pos != NULL )
	{
		CMenuObject *pobj; 
		void *vptr;
		CString string;

		m_menus.GetNextAssoc( pos, string, vptr );
		pobj=(CMenuObject *)vptr;
		if(pobj)
			delete(pobj);
	}

	m_menus.RemoveAll();
	m_menuIDMap.RemoveAll();
}

void COutputWindow::OnFinalRelease()
{
	// When the last reference for an automation object is released
	// OnFinalRelease is called.  The base class will automatically
	// deletes the object.  Add additional cleanup required for your
	// object before calling the base class.

	CFrameWnd::OnFinalRelease();
}

void COutputWindow::Update()
{
	::UpdateWindow(m_hWnd);
}

BEGIN_MESSAGE_MAP(COutputWindow, CFrameWnd)
	//{{AFX_MSG_MAP(COutputWindow)
	ON_WM_CREATE()
	ON_WM_DESTROY()
	ON_COMMAND(IDCLOSE, OnClose)
	ON_UPDATE_COMMAND_UI(IDCLOSE, OnUpdateClose)
	ON_WM_HIBERNATE()
	ON_WM_ACTIVATE()
	ON_WM_SETFOCUS()
	ON_WM_CHAR()
	ON_WM_KEYDOWN()
	ON_WM_KEYUP()
	ON_WM_SYSCHAR()
	ON_WM_SYSKEYDOWN()
	ON_WM_SYSKEYUP()
	ON_MESSAGE(WM_SETTINGCHANGE,OnSettingChange) //PSPCFIX
	ON_COMMAND(IDOK, OnOk)
	ON_WM_SIZE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

BEGIN_DISPATCH_MAP(COutputWindow, CFrameWnd)
	//{{AFX_DISPATCH_MAP(COutputWindow)
		// NOTE - the ClassWizard will add and remove mapping macros here.
	//}}AFX_DISPATCH_MAP
END_DISPATCH_MAP()

// Note: we add support for IID_IOutputWindow to support typesafe binding
//  from VBA.  This IID must match the GUID that is attached to the 
//  dispinterface in the .ODL file.

// {D4FE2D22-3DDF-11D2-890A-0000E73336C3}
static const IID IID_IOutputWindow =
{ 0xd4fe2d22, 0x3ddf, 0x11d2, { 0x89, 0xa, 0x0, 0x0, 0xe7, 0x33, 0x36, 0xc3 } };

BEGIN_INTERFACE_MAP(COutputWindow, CFrameWnd)
	INTERFACE_PART(COutputWindow, IID_IOutputWindow, Dispatch)
END_INTERFACE_MAP()

/////////////////////////////////////////////////////////////////////////////
// COutputWindow message handlers

BOOL COutputWindow::PreCreateWindow(CREATESTRUCT& cs) 
{
	// TODO: Add your specialized code here and/or call the base class
	BOOL retval=CFrameWnd::PreCreateWindow(cs);
	//cs.style&=~WS_VISIBLE;

	{
		RECT rectMe;
		rectMe.top=cs.y;
		rectMe.left=cs.x;
		rectMe.right=cs.x+cs.cx;
		rectMe.bottom=cs.y+cs.cy;
		ClipToVisibleScreenRect(&rectMe);
		cs.x=rectMe.left;
		cs.y=rectMe.top;
		cs.cx=rectMe.right-rectMe.left;
		cs.cy=rectMe.bottom-rectMe.top;
	}

	cs.dwExStyle|=WS_EX_NOANIMATION;

	return retval;
}


int COutputWindow::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	//now it's okay to resize the main window to fill the screen..
	if(gbShowEditorWindow)
		AfxGetMainWnd()->MoveWindow(&(((CMainFrame *)AfxGetMainWnd())->m_rectSavedBounds),true);
	
	m_bChaining=false;

	//GetWindowRect(&m_rectSavedBounds);
	//MoveWindow(1000,0,m_rectSavedBounds.right-m_rectSavedBounds.left,m_rectSavedBounds.bottom-m_rectSavedBounds.top,true);
	//make the window open off-screen.
	GetWindowRect(&m_rectSavedBounds);
	MoveWindow( 1000, 1000, lpCreateStruct->cx, lpCreateStruct->cy );

	if (CFrameWnd::OnCreate(lpCreateStruct) == -1)
		return -1;

	//remove the noanimation style after the window is created and opened so that
	//we still get a task bar icon..
	DWORD dwStyle;
	dwStyle=GetWindowLong(m_hWnd,GWL_EXSTYLE);
	dwStyle&=~WS_EX_NOANIMATION;
	SetWindowLong(m_hWnd,GWL_EXSTYLE,dwStyle);

#ifdef _POCKET
   if( !m_wndCommandBar.Create( this ) ||
       !m_wndCommandBar.InsertMenuBar( IDR_OUTPUTFRAME ) ||
       !m_wndCommandBar.AddAdornments() )
   {
      TRACE0( "Failed to create CommandBar\n" );
      return -1;
   }
   if( gbShowEditorWindow )
      ShowDoneButton( TRUE );
#else
   // Add Exit and Help buttons
	if (!AddAdornments( 0 ))
	{
		TRACE0("Failed to add exit and help buttons\n");
		return -1; 
	}
#endif

   CMenu *pMenu = GetMenu();
	if(pMenu)
	{
      pMenu->DeleteMenu(0,MF_BYPOSITION);
#ifdef _POCKET
      ::SendMessage( m_wndCommandBar.m_hWnd, TB_DELETEBUTTON, 0, 0 );
#endif
		CommandBar_Show(m_hCommandBar,false);
		CommandBar_Show(m_hCommandBar,true);
	}

	MoveWindow(&m_rectSavedBounds,true);
	if(dlgOutput.m_hWnd)
		dlgOutput.m_PictureBox2.SetFocus();
	return 0;
}


void COutputWindow::OnDestroy() 
{
	CWnd *pWnd;

	if(gbScriptRunning)
	{//**MARCH99 - send close message when output window is closing

		// EMP DEC 2005 changed to behave properly with optional OK button

		if (!m_bOKButton)
		{
			unsigned char *parms=0;

			pEngine->SendScriptMessage(L"output_close",VT_EMPTY,0,parms);
		}
	}

	//**MARCH99 new
	SetWaitCursor(false);

	gbScriptRunning=false;

	DebugStr(L"\nONDESTROY\n");	
	gbEnterModalLoop=false;

	if(!gbQuitting && (pWnd=AfxGetMainWnd()) && ::IsWindow(pWnd->m_hWnd) && pWnd->IsWindowVisible())
		pWnd->EndModalLoop(0);
	
	// PSPCFIX - is this necessary?  EMP does not blow up
	dlgOutput.m_PictureBox2.DestroyWindow();
	dlgOutput.DestroyWindow();

	CFrameWnd::OnDestroy();

   doWriteDebug(TEXT("5"));
	OSVERSIONINFO versionInfo;
	versionInfo.dwOSVersionInfoSize = sizeof(OSVERSIONINFO);
	if (!GetVersionEx(&versionInfo))
	{
		versionInfo.dwMajorVersion = 2;
	}

	if (1 || versionInfo.dwMajorVersion < 5)
	{
		if (gbShowEditorWindow)
		{
			gpOutputWindow=0; //	EMP blows up on Mobile 5

		}
	}
// EMP test #ifdef _POCKET
   if( !gbShowEditorWindow )
      PostQuitMessage( 0 );
// EMP test #endif
}

void COutputWindow::PostNcDestroy() 
{
	pEngine->ReleaseScriptEngine();	
	dlgOutput.DestroyWindow();
	CFrameWnd::PostNcDestroy();

	if(!AfxGetMainWnd())
		return;

	/* MMD 2009-05-12: The WM6 error!
		The if clause was breaking things so it was inverted so
		that if could be eliminated while leaving else untouched.
		2 lines after comment replace 4 lines in comment.
	if(!m_bChaining && (m_bLaunchedWithFile || gbCloseOnEnd)) //the m_bLaunchedWithFile is probably redundant and should be removed.
		AfxGetMainWnd()->PostMessage( WM_COMMAND, ID_APP_EXIT, 0 );
	else
		AfxGetMainWnd()->BringWindowToTop();
	*/
	if( m_bChaining || ( !m_bLaunchedWithFile && !gbCloseOnEnd ) )
		AfxGetMainWnd()->BringWindowToTop();
	m_bChaining=false;

}

BOOL COutputWindow::OnCmdMsg(UINT nID, int nCode, void* pExtra, AFX_CMDHANDLERINFO* pHandlerInfo) 
{
	//call the handler if one was found (ClassWizard defined handlers)
	if(pHandlerInfo)
		return CFrameWnd::OnCmdMsg(nID, nCode, pExtra, pHandlerInfo);
	else
	{
		if(nCode==CN_UPDATE_COMMAND_UI)
		{//enable all menu items and controls by default
			((CCmdUI *)pExtra)->Enable(true);
		}
		else
		{
			CMenuObject *pcmoWhich;
			void *vptr;
         			
         DebugStr(TEXT("\nRECEIVED COMMAND: ID = %lu (0x%08lx), CODE = %ld (0x%08lx)\n"),nID,nID,nCode,nCode);

//         if( nID == WM_NOTIFY )
//         {
//         }
//         else
//         {
		      if(m_menuIDMap.Lookup((void *)nID,vptr))
		      {
			      pcmoWhich=(CMenuObject *)vptr;
			      DebugStr(TEXT("***Maps to ID %s (menu item %s)\n"),pcmoWhich->cstrKey,pcmoWhich->cstrText);
			      if(gbScriptRunning)
			      {
				      unsigned char *parms=0;
				      CString cstrMessage;

				      cstrMessage=pcmoWhich->cstrKey;
				      cstrMessage+=TEXT("_click");

				      pEngine->SendScriptMessage(cstrMessage,VT_EMPTY,0,parms);
			      }

		      }
		      else
		      {
			      DebugStr(TEXT("***No valid mapping***\n"));
#ifdef _POCKET
               return CFrameWnd::OnCmdMsg( nID, nCode, pExtra, pHandlerInfo );
#endif
		      }
//         }
		}
	}
	return true;

} 

//these next two functions are really pointless, but their presence is necessary so
//our custom menu processing stuff won't have to handle this case.. (for the closebox,
//the pHandlerInfo parameter to OnCmdMsg will contain a value, so our code will pass
//the message on to the default implementation, which will call these functions).

void COutputWindow::OnClose() 
{
	// TODO: Add your command handler code here
	//MessageBox(TEXT("CLOSING"),TEXT(""),MB_OK);
	//DebugStr(L"\nONCLOSE\n");
	DestroyWindow();
	//CFrameWnd::OnClose();
}

void COutputWindow::OnUpdateClose(CCmdUI* pCmdUI) 
{

	pCmdUI->Enable(true);
}

void COutputWindow::OnHibernate() 
{
	DebugStr(TEXT("\n\n~~~~~~~~~WM_HIBERNATE!!~~~~~~~~~~~~~\n\n"));
	if(gbScriptRunning)
	{
		unsigned char *parms=0;


		pEngine->SendScriptMessage(L"Hibernate",VT_EMPTY,0,parms);
	}
}

void COutputWindow::OnActivate(UINT nState, CWnd* pWndOther, BOOL bMinimized) 
{
	CFrameWnd::OnActivate(nState, pWndOther, bMinimized);
	
	DebugStr(TEXT("\n\n~~~~~~~~~WM_ACTIVATE!!~~~~~~~~~~~~~\n\n"));
	if(gbScriptRunning)
	{
		unsigned char *parms=0;


		pEngine->SendScriptMessage(L"Activate",VT_EMPTY,0,parms);
		if(dlgOutput.m_hWnd)
			dlgOutput.SetFocus();
	}
	
}


void COutputWindow::OnSetFocus(CWnd* pOldWnd) 
{
	CFrameWnd::OnSetFocus(pOldWnd);
	
	if(dlgOutput.m_hWnd)
		dlgOutput.SetFocus();
	
}

/*BOOL COutputWindow::PreTranslateMessage(MSG* pMsg) 
{
	// TODO: Add your specialized code here and/or call the base class
	return CFrameWnd::PreTranslateMessage(pMsg);
	switch(pMsg->message)
	{
	case WM_KEYDOWN:
	case WM_SYSKEYDOWN:
	case WM_KEYUP:
	case WM_SYSKEYUP:
	case WM_CHAR:
		//MessageBeep(MB_ICONQUESTION);
		//dlgOutput.SendMessage(pMsg->message,pMsg->wParam,pMsg->lParam);
		if(m_bKeyPreview)
		{
			//dlgOutput.SendMessage(pMsg->message,pMsg->wParam,pMsg->lParam);
			return dlgOutput.PreTranslateMessage(pMsg);
			return 0;
		}
	}
	return CFrameWnd::PreTranslateMessage(pMsg);
}
*/

void COutputWindow::OnChar(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	// TODO: Add your message handler code here and/or call default
//	if(m_bKeyPreview)
//		dlgOutput.PostMessage(WM_CHAR,(WPARAM)nChar,MAKELPARAM(nRepCnt,nFlags));
	CFrameWnd::OnChar(nChar, nRepCnt, nFlags);
}


void COutputWindow::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	// TODO: Add your message handler code here and/or call default
	//if(m_bKeyPreview)
		dlgOutput.PostMessage(WM_KEYDOWN,(WPARAM)nChar,MAKELPARAM(nRepCnt,nFlags));
	
	CFrameWnd::OnKeyDown(nChar, nRepCnt, nFlags);
}

void COutputWindow::OnKeyUp(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	// TODO: Add your message handler code here and/or call default
	//if(m_bKeyPreview)
		dlgOutput.PostMessage(WM_KEYUP,(WPARAM)nChar,MAKELPARAM(nRepCnt,nFlags));
	
	CFrameWnd::OnKeyUp(nChar, nRepCnt, nFlags);
}


void COutputWindow::OnSysChar(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	// TODO: Add your message handler code here and/or call default
//	if(m_bKeyPreview)
//		dlgOutput.PostMessage(WM_SYSCHAR,(WPARAM)nChar,MAKELPARAM(nRepCnt,nFlags));
	CFrameWnd::OnSysChar(nChar, nRepCnt, nFlags);
}


void COutputWindow::OnSysKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	// TODO: Add your message handler code here and/or call default
	//if(m_bKeyPreview)
		dlgOutput.PostMessage(WM_SYSKEYDOWN,(WPARAM)nChar,MAKELPARAM(nRepCnt,nFlags));
	
	CFrameWnd::OnSysKeyDown(nChar, nRepCnt, nFlags);
}

void COutputWindow::OnSysKeyUp(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	// TODO: Add your message handler code here and/or call default
	//if(m_bKeyPreview)
		dlgOutput.PostMessage(WM_SYSKEYUP,(WPARAM)nChar,MAKELPARAM(nRepCnt,nFlags));
	
	CFrameWnd::OnSysKeyUp(nChar, nRepCnt, nFlags);
}


LRESULT COutputWindow::OnSettingChange( WPARAM wParam, LPARAM lParam )
{
#if (_WIN32_WCE != 200) && defined(_WIN32_WCE_PSPC) //**MARCH99 - no aygshell/SIP in HPC
   switch( wParam )             
   {
	case SPI_SETSIPINFO:
      {
         SIPINFO si;
         memset( &si, 0, sizeof( si ) );
         si.cbSize = sizeof( si );
         if( mySHSipInfo( SPI_GETSIPINFO, lParam, &si, 0 ) ) 
         {
            RECT rect;
            unsigned char *parms = 0;
            int iHeight = si.rcVisibleDesktop.bottom - si.rcVisibleDesktop.top;

#ifdef _POCKET
            int iDelta = (si.fdwFlags & SIPF_ON) ? 0 : MENU_HEIGHT;
            iHeight -= iDelta;
#endif
            MoveWindow(
               si.rcVisibleDesktop.left,
               si.rcVisibleDesktop.top,
               si.rcVisibleDesktop.right -  si.rcVisibleDesktop.left,
               iHeight,
               TRUE );
            GetClientRect( &rect );
#  ifndef _POCKET
   doWriteDebug(TEXT("3"));
			if (gpOutputWindow)
            rect.top += CommandBar_Height( gpOutputWindow->m_hCommandBar );
#  endif
            dlgOutput.myMoveWindow( &rect );
            pEngine->SendScriptMessage( _T( "KeyboardStatusChanged" ), VT_EMPTY, 0, parms );
         }
         break;
      }
   default:
      {
      }
   }
#endif

	return 0;
}


void COutputWindow::OnOk() 
{
	DebugStr(L"\nONOK\n");

	if (m_bOKButton)
	{
		{
			unsigned char *parms=0;

			if (!pEngine->SendScriptMessage(L"output_close",VT_EMPTY,0,parms)) DestroyWindow();
		}
	}
	else
	{
		DestroyWindow();
	}
}

bool recurringSize = false;

void COutputWindow::OnSize(UINT nType, int cx, int cy) 
{
	unsigned char *parms = 0;
	CFrameWnd::OnSize(nType, cx, cy);
	RECT r;

	r.left = 0;
	r.top = 0;
#  ifndef _POCKET
   doWriteDebug(TEXT("4"));
	if (gpOutputWindow)
    r.top += CommandBar_Height( gpOutputWindow->m_hCommandBar );
#  endif
	r.right = cx;
	r.bottom = cy;
	dlgOutput.myMoveWindow( &r );
	if( pEngine && !recurringSize)
	{
		recurringSize = true;
	    pEngine->SendScriptMessage( _T("Output_Size"), VT_EMPTY, 0, parms );
		recurringSize = false;
	}
}