// MainFrm.cpp : implementation of the CMainFrame class
//

#include "stdafx.h"
#include "script.h"

#include "MainFrm.h"
#include "outputwindow.h"
#include "scriptview.h"
#include "utility.h"

#if(_WIN32_WCE != 200)  //**MARCH99 - no aygshell in HPC
#ifdef _WIN32_WCE_PSPC
#include <aygshell.h> //PSPCFIX - had to copy aygshell.h to include directory for HPCPRO
#endif
#endif


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif
// Array tbSTDButton contains relevant buttons of bitmap IDB_STD_SMALL_COLOR

extern HWND ghwndMain;
extern CWnd *gpcwndMain;
extern BOOL gbScriptRunning;
extern BOOL gbQuitting;
extern UINT giNextMenuID;

extern class COutputWindow *gpOutputWindow;
extern LaunchModeType gLaunchMode;
extern bool gbLaunching;

extern bool gbShowEditorWindow;	//Is the main window shown?
extern bool gbAllowEmptyLaunch;	//Can the app be launched without a file?
extern bool gbCloseOnEnd;		//Does entire app close when program exits?
extern bool gbAllowSave;			//Can apps be saved?

static TBBUTTON g_tbSTDButton[] = {
	{0, 0,				TBSTATE_ENABLED, TBSTYLE_SEP,    0, 0, 0, -1},  
	{0,	ID_FILE_NEW,	TBSTATE_ENABLED, TBSTYLE_BUTTON, 0, 0, 0, -1},
	{1, ID_FILE_OPEN,	TBSTATE_ENABLED, TBSTYLE_BUTTON, 0, 0, 0, -1},
	{2, ID_FILE_SAVE,	TBSTATE_ENABLED, TBSTYLE_BUTTON, 0, 0, 0, -1},
	{0, 0,				TBSTATE_ENABLED, TBSTYLE_SEP,    0, 0, 0, -1},
	{3, ID_EDIT_CUT,	TBSTATE_ENABLED, TBSTYLE_BUTTON, 0, 0, 0, -1},
	{4, ID_EDIT_COPY,	TBSTATE_ENABLED, TBSTYLE_BUTTON, 0, 0, 0, -1},
	{5, ID_EDIT_PASTE,	TBSTATE_ENABLED, TBSTYLE_BUTTON, 0, 0, 0, -1},
	{0, 0,				TBSTATE_ENABLED, TBSTYLE_SEP,    0, 0, 0, -1},
	{7, ID_TOOL_RUN,	TBSTATE_ENABLED, TBSTYLE_BUTTON, 0, 0, 0, -1}//,
	//{0, 0,				TBSTATE_ENABLED, TBSTYLE_SEP,    0, 0, 0, -1},
	//{6, ID_APP_ABOUT,	TBSTATE_ENABLED, TBSTYLE_BUTTON, 0, 0, 0, -1},
	//{0, 0,				TBSTATE_ENABLED, TBSTYLE_SEP,    0, 0, 0,  0}
};

//PSPCFIX
static TBBUTTON g_tbSHORTButton[] = {
	//{0, 0,				TBSTATE_ENABLED, TBSTYLE_SEP,    0, 0, 0, -1},  
	{7, ID_TOOL_RUN,	TBSTATE_ENABLED, TBSTYLE_BUTTON, 0, 0, 0, -1}//,
};

static TCHAR *gszShortTips[]={0,TEXT("Run (Ctrl+R)")};

static TCHAR *gszTips[]={0,TEXT("New (Ctrl+N)"),TEXT("Open (Ctrl+O)"),TEXT("Save (Ctrl+S)"),TEXT("Cut (Ctrl+X)"),TEXT("Copy (Ctrl+C)"),TEXT("Paste (Ctrl+V)"),TEXT("Run (Ctrl+R)")};
/////////////////////////////////////////////////////////////////////////////
// CMainFrame

IMPLEMENT_DYNCREATE(CMainFrame, CFrameWnd)

BEGIN_MESSAGE_MAP(CMainFrame, CFrameWnd)
	//{{AFX_MSG_MAP(CMainFrame)
	ON_WM_CREATE()
	ON_WM_DESTROY()
	ON_WM_CLOSE()
	ON_WM_INITMENUPOPUP()
	ON_COMMAND(ID_HELP, OnHelp)
	ON_MESSAGE(WM_SETTINGCHANGE,OnSettingChange) //PSPCFIX
	ON_WM_ACTIVATE()
	//}}AFX_MSG_MAP
	// Global help commands
	ON_COMMAND(ID_HELP, CFrameWnd::OnHelp)
	ON_MESSAGE(0xC104, OnHelp) //HPC PRO ONLY
	ON_MESSAGE(WM_HELP,OnHelp)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMainFrame construction/destruction

CMainFrame::CMainFrame()
{
	// TODO: add member initialization code here
}

CMainFrame::~CMainFrame()
{
}

int CMainFrame::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	DWORD dwStyle;
	RECT rectMe;
	RECT rectEmpty;


	//create dummy picturebox...
	SetRect(&rectEmpty,1000,1000,5,5);
	m_dummypicturebox.Create(L"",L"dummy",0,rectEmpty,this,7890,NULL);


	gpcwndMain=this;
	
	GetWindowRect(&rectMe);
	//ClipToVisibleScreenRect(&rectMe);
	MoveWindow(&rectMe,false);
	CopyRect(&m_rectSavedBounds,&rectMe);

	/*{
		TCHAR szBuf[200];
		wsprintf(szBuf,L"%i,%i - %i,%i",rectMe.left,rectMe.top,rectMe.right,rectMe.bottom);
		MessageBox(szBuf,0,MB_OK);
	}*/
	//GetWindowRect(&m_rectSavedBounds);
	
	MoveWindow(1000,1000,lpCreateStruct->cx,lpCreateStruct->cy);

   if (CFrameWnd::OnCreate(lpCreateStruct) == -1)
		return -1;
	// Add the buttons to the CommandBar.
	// NOTE: In order for AddAdornments() to work properly, NImages must be
	//       the true number of button images in the bitmap file (even if not
	//       all of them are used).



	//remove the noanimation style after the window is created and opened so that
	//we still get a task bar icon..
	if(gbShowEditorWindow)
	{
		dwStyle=GetWindowLong(m_hWnd,GWL_EXSTYLE);
		dwStyle&=~WS_EX_NOANIMATION;
		SetWindowLong(m_hWnd,GWL_EXSTYLE,dwStyle);
	}
	
	if(gbShowEditorWindow)
	{
		CRect rectMe;
		bool bWide;
		int iWidth;
		
		GetWindowRect(&rectMe);
		iWidth=rectMe.Width();
		bWide=iWidth>340;

#ifdef _POCKET
		  m_ToolTipsTable[0] = MakeStrFromRes( IDS_CAP_FILE );
		  m_ToolTipsTable[1] = MakeStrFromRes( IDS_CAP_EDIT );
		  m_ToolTipsTable[2] = MakeStrFromRes( IDS_CAP_TOOLS );
		  m_ToolTipsTable[3] = MakeStrFromRes( ID_TOOLS_RUN );

		  if( !m_wndCommandBar.Create( this ) ||
			  !m_wndCommandBar.InsertMenuBar( IDR_MAINFRAME /* EMP IDR_MAINFRAME_POCKET */ ) ||
			  !m_wndCommandBar.AddAdornments() ||
			  !m_wndCommandBar.LoadToolBar( IDR_MAINFRAME_POCKET ) ||
			  !m_wndCommandBar.SendMessage( TB_SETTOOLTIPS, (WPARAM)1, (LPARAM)m_ToolTipsTable ) )
		  {
			 TRACE0( "Failed to create CommandBar\n" );
			 return -1;
		  }
//   static TBBUTTON buttons[] = { { 0, ID_TOOL_RUN, TBSTATE_ENABLED, TBSTYLE_BUTTON, 0, 0 } };
//   InsertButtons( buttons, sizeof(buttons)/sizeof(TBBUTTON), IDR_MAINFRAME_POCKET, 1 );
#else
			if (!InsertButtons( (bWide)?g_tbSTDButton:g_tbSHORTButton,
				(((bWide)?sizeof(g_tbSTDButton):sizeof(g_tbSHORTButton))/sizeof(TBBUTTON)),		// NButtons
				IDR_MAINFRAME,					// toolbar bitmap
				(bWide)?8:8 ))				// NImages
			{
				TRACE0("Failed to add command bar buttons\n");
				return -1;
			}
			// POCKET fix
				//vc6fix
			#if(UNDER_CE==211)
			::CommandBar_AddToolTips(m_hCommandBar,sizeof((bWide)?gszTips:gszShortTips),(bWide)?gszTips:gszShortTips);
			#else
			// 03/05/2001 MMD
			// HPC 2K needs 2 colons (::) like above, otherwise no colons
			::CommandBar_AddToolTips(m_hCommandBar, sizeof((bWide)?gszTips:gszShortTips), (bWide)?gszTips:gszShortTips );
			#endif
#endif
	}
	//CommandBar_InsertMenubar(m_hCommandBar,AfxGetInstanceHandle(),IDR_MAINFRAME,2);

#ifndef _POCKET
   // Add Exit and Help buttons
	if (!AddAdornments( CMDBAR_HELP ))
	{
		TRACE0("Failed to add exit and help buttons\n");
		return -1; 
	}
#endif
   
	ghwndMain=m_hWnd;

	
	return 0;
}

BOOL CMainFrame::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs
	
	cs.style &= ~WS_CLIPCHILDREN;

	//this prevents the duplicate opening animation, but has to be un-set in oncreate() or
	//we won't get our task bar button
	cs.dwExStyle |= WS_EX_NOANIMATION;

   if(!gbShowEditorWindow)
	{//no button for the editor in runtime mode or when launching a protected app..
      cs.x = 0;
      cs.y = 0;
      cs.cx = 0;
      cs.cy = 0;
		cs.style &= ~WS_VISIBLE | WS_CAPTION;
#ifdef _POCKET
      cs.style |= WS_DISABLED;
#endif
   }
	else
	{
		RECT rectMe;
		rectMe.top=cs.y;
		rectMe.left=cs.x;
		rectMe.right=cs.x+cs.cx;
		rectMe.bottom=cs.y+cs.cy;
		ClipToVisibleScreenRect(&rectMe);
		cs.x=rectMe.left;
		cs.y=rectMe.top;
		cs.cx=rectMe.right-rectMe.left;
		cs.cy=rectMe.bottom-rectMe.top;
	}
	return CFrameWnd::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// CMainFrame diagnostics

#ifdef _DEBUG
void CMainFrame::AssertValid() const
{
	CFrameWnd::AssertValid();
}

void CMainFrame::Dump(CDumpContext& dc) const
{
	CFrameWnd::Dump(dc);
}

#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CMainFrame message handlers



void CMainFrame::OnDestroy() 
{

	gbQuitting=true;
	EndModalLoop(0);
#ifdef _POCKET
   for( int i = 0; i < 4; i++ )
      delete m_ToolTipsTable[i];
#endif

   doWriteDebug(TEXT("1"));

	if(gpOutputWindow)
	{
		gpOutputWindow->DestroyWindow();
	}

	CFrameWnd::OnDestroy();
}

void CMainFrame::OnClose() 
{
   doWriteDebug(TEXT("2"));
	if(gpOutputWindow)
	{
		gpOutputWindow->DestroyWindow(); 
		AfxGetMainWnd()->PostMessage(WM_CLOSE,0,0);
		return;
	}
	CFrameWnd::OnClose();
}
#define kMaxRecentFilenameLength 30

void CMainFrame::OnInitMenuPopup(CMenu* pPopupMenu, UINT nIndex, BOOL bSysMenu) 
{
	CFrameWnd::OnInitMenuPopup(pPopupMenu, nIndex, bSysMenu);
	
	int iNumItems, iItemIter;
	
	iNumItems=pPopupMenu->GetMenuItemCount();

	for(iItemIter=0;iItemIter<iNumItems;iItemIter++)
	{
		int iLen;
		CString cstrItem;

		
		if(pPopupMenu->GetMenuString(iItemIter,cstrItem,MF_BYPOSITION))
		{
			CDC *pDC;

			iLen=cstrItem.GetLength();
			if(_tcsstr(cstrItem,kMagicVNSBFileName))
			{
				pPopupMenu->DeleteMenu(iItemIter,MF_BYPOSITION);
				iNumItems--;
				iItemIter--;
			}
			else if(iLen>kMaxRecentFilenameLength)
			{
				RECT rect;
				int iWidth;
				HFONT hfontOld;


				pDC=AfxGetMainWnd()->GetDC();
				hfontOld=(HFONT)::SelectObject(pDC->m_hDC,(HFONT)GetStockObject(SYSTEM_FONT));

				iWidth=pDC->GetDeviceCaps(HORZRES)-100;
				SetRect(&rect,0,0,10,20);
				pDC->DrawText(cstrItem,&rect,DT_CALCRECT|DT_SINGLELINE);
				while(rect.right>iWidth)
				{
					CString cstrNew;
					
					int iLen=cstrItem.GetLength()-20;

					cstrNew=cstrItem.Right(iLen/2);

					cstrItem=cstrItem.Left(iLen/2);
					cstrItem+=TEXT("...");

					
					cstrItem+=cstrNew;
					
					SetRect(&rect,0,0,10,20);
					pDC->DrawText(cstrItem,&rect,DT_CALCRECT|DT_SINGLELINE);
				}
				
				pPopupMenu->ModifyMenu(iItemIter,MF_BYPOSITION|MF_STRING,pPopupMenu->GetMenuItemID(iItemIter),(LPCTSTR)cstrItem);
				::SelectObject(pDC->m_hDC,(HFONT)hfontOld);
				AfxGetMainWnd()->ReleaseDC(pDC);

			}
			

		}
	}
}

void CMainFrame::OnHelp() 
{
	CFrameWnd::OnHelp();
}

//PSPCFIX

LRESULT CMainFrame::OnSettingChange(WPARAM wParam, LPARAM lParam)
{
#if (_WIN32_WCE != 200) && defined(_WIN32_WCE_PSPC) //**MARCH99 - no aygshell/SIP in HPC
   SIPINFO si;
   switch( wParam )             
   {
   case SPI_SETSIPINFO:
      {
         RECT rectMe;

         memset( &si, 0, sizeof( si ) );
         si.cbSize = sizeof( si );
         if( gbShowEditorWindow && mySHSipInfo( SPI_GETSIPINFO, lParam, &si, 0 ) )
         {
            int iHeight = si.rcVisibleDesktop.bottom - si.rcVisibleDesktop.top;
#ifdef _POCKET
            int iDelta = (si.fdwFlags & SIPF_ON) ? 0 : MENU_HEIGHT;
            iHeight -= iDelta;
#endif
            MoveWindow(
               si.rcVisibleDesktop.left,
               si.rcVisibleDesktop.top,
               si.rcVisibleDesktop.right -  si.rcVisibleDesktop.left,
               iHeight,
               TRUE );     
            GetWindowRect( &rectMe );
            CopyRect( &m_rectSavedBounds, &rectMe );
			}
         break;
      }
   default:
      {
      }
   }
#endif //no aygshell/SIP in HPC

   return 0;
}

void CMainFrame::OnActivate(UINT nState, CWnd* pWndOther, BOOL bMinimized) 
{
	CFrameWnd::OnActivate(nState, pWndOther, bMinimized);
#ifdef _WIN32_WCE_PSPC
   OnSettingChange( SPI_SETSIPINFO, 0 );
#endif
}

#ifdef _POCKET
LPTSTR CMainFrame::MakeStrFromRes( UINT strResID )
{
	TCHAR buffer[255];
	TCHAR* theString;

	::LoadString(AfxGetInstanceHandle(), strResID, buffer, 255);
	theString = new TCHAR[lstrlen(buffer) + 1];
	lstrcpy(theString, buffer);
	return theString;
} // MakeStrFromRes
#endif
