#define __FULLSCREEN_CPP__

#include "stdafx.h"
#include "FullScreen.h"

HWND	hWndInputPanel = NULL;
HWND	hWndTaskBar    = NULL;
HWND	hWndSipButton  = NULL;

RECT	rtDesktop;
RECT	rtNewDesktop;
RECT	rtInputPanel;
RECT	rtSipButton;
RECT	rtTaskBar;

int InitFullScreen (void)
{
	int	Result = 0;

	__try
	{
		if (SystemParametersInfo(SPI_GETWORKAREA, 0, &rtDesktop, NULL) == 1)
		{
			// Successful obtain the system working area (Desktop)
			SetRect(&rtNewDesktop, 0, 0, 240, 320);

			// Change system setting
			SystemParametersInfo(SPI_SETWORKAREA, 0, &rtNewDesktop, SPIF_UPDATEINIFILE);
		}

		// Find the Input panel window handle
		hWndInputPanel = FindWindow(TEXT("SipWndClass"), NULL);
		// Checking...
		if (hWndInputPanel != NULL)
			// Get the original Input panel window size
			GetWindowRect(hWndInputPanel, &rtInputPanel);

		// Find the SIP Button window handle
		hWndSipButton = FindWindow(TEXT("MS_SIPBUTTON"), NULL);
		// Checking...
		if (hWndSipButton != NULL)
			// Get the original Input panel window size
			GetWindowRect(hWndSipButton, &rtSipButton);

		// Find the Taskbar window handle
		hWndTaskBar = FindWindow(TEXT("HHTaskBar"), NULL);
		// Checking...
		if (hWndTaskBar != NULL)
			// Get the original taskbar window size
			GetWindowRect(hWndTaskBar, &rtTaskBar);
	}
	__except(EXCEPTION_EXECUTE_HANDLER)
	{
		// PUT YOUR ERROR LOG CODING HERE

		// Set return value
		Result = 1;
	}

	return Result;
}

int DoFullScreen (bool mode)
{
	int	Result = 0;

	__try
	{
		if (mode)
		{
			// Update window working area size
			SystemParametersInfo(SPI_SETWORKAREA, 0, &rtNewDesktop, SPIF_UPDATEINIFILE);

			if (NULL != hWndTaskBar)
			{
				// Hide the TaskBar
				MoveWindow(hWndTaskBar, 
						   0, 
						   rtNewDesktop.bottom, 
						   rtTaskBar.right - rtTaskBar.left, 
						   rtTaskBar.bottom - rtTaskBar.top, 
						   false);
			}

			if (NULL != hWndInputPanel)
			{
				// Reposition the input panel 
				MoveWindow(hWndInputPanel,
						   0,
						   rtNewDesktop.bottom - (rtInputPanel.bottom - rtInputPanel.top), 
						   rtInputPanel.right - rtInputPanel.left, 
						   rtInputPanel.bottom - rtInputPanel.top,
						   false);
			}

			// Ensure the SIP button is found (Only for PocketPC)
			if (NULL != hWndSipButton)
			{
				// Hide the input panel 
				MoveWindow(hWndInputPanel,
						   0,
						   rtNewDesktop.bottom, 
						   rtSipButton.right - rtSipButton.left, 
						   rtSipButton.bottom - rtSipButton.top,
						   false);
			}
		}
		else
		{
			// Update window working area size
			SystemParametersInfo(SPI_SETWORKAREA, 0, &rtDesktop, SPIF_UPDATEINIFILE);

			// Restore the TaskBar
			if (NULL != hWndTaskBar)
			{
				MoveWindow(hWndTaskBar, 
						   rtTaskBar.left, 
						   rtTaskBar.top,
						   rtTaskBar.right - rtTaskBar.left,
						   rtTaskBar.bottom - rtTaskBar.top,
						   false);
			}

			// Restore the input panel
			if (NULL != hWndInputPanel)
			{
				MoveWindow(hWndInputPanel, 
						   rtDesktop.left,
						   rtDesktop.bottom - (rtInputPanel.bottom - rtInputPanel.top) - (rtTaskBar.bottom - rtTaskBar.top), 
						   rtInputPanel.right - rtInputPanel.left,
						   rtInputPanel.bottom - rtInputPanel.top,
						   false);
			}

			// Ensure the SIP button is found (Only for PocketPC)
			if (NULL != hWndSipButton)
			{
				// Hide the input panel 
				MoveWindow(hWndSipButton,
						   rtSipButton.left,
						   rtSipButton.top, 
						   rtSipButton.right - rtSipButton.left, 
						   rtSipButton.bottom - rtSipButton.top,
						   false);
			}
		}
	}
	__except(EXCEPTION_EXECUTE_HANDLER)
	{
		// PUT YOUR ERROR LOG CODING HERE

		// Set return value
		Result = 1;
	}

	return Result;
}
