// BreakpointDialog.cpp : implementation file
//

#include "stdafx.h"
#include "script.h"
#include "TabEdit.h"
#include "BreakpointDialog.h"

#undef _DEBUG		// EMP DIKEO

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern bool gbScrollToError;

static bool gbLastRectValid=false;
static RECT grectLast;

/////////////////////////////////////////////////////////////////////////////
// CBreakpointDialog dialog


CBreakpointDialog::CBreakpointDialog(CWnd* pParent /*=NULL*/)
#ifdef _WIN32_WCE_PSPC
	: CDialog(IDD_BREAKPOINTDIALOG_PPC, pParent)
#else
	: CDialog(IDD_BREAKPOINTDIALOG, pParent)
#endif
{
#ifdef _WIN32_WCE_PSPC
	IDD = IDD_BREAKPOINTDIALOG_PPC;
#else
	IDD = IDD_BREAKPOINTDIALOG;
#endif
	//{{AFX_DATA_INIT(CBreakpointDialog)
	m_Caption = _T("Your program is stopped at a breakpoint.  Press the 'continue' button to continue program execution.");
	m_ExecuteString = _T("");
	//}}AFX_DATA_INIT
}


void CBreakpointDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CBreakpointDialog)
	DDX_Control(pDX, IDC_EDIT2, m_EditBox);
	DDX_Text(pDX, IDC_EDIT1, m_Caption);
	DDX_Text(pDX, IDC_EDIT2, m_ExecuteString);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CBreakpointDialog, CDialog)
	//{{AFX_MSG_MAP(CBreakpointDialog)
	ON_BN_CLICKED(IDB_EXECUTE, OnExecute)
	ON_BN_CLICKED(IDB_EVALUATE, OnEvaluate)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CBreakpointDialog message handlers

void CBreakpointDialog::OnExecute() 
{
	bool bSave;


	bSave=gbScrollToError;
	gbScrollToError=false;
	UpdateData(true);
	m_pEngine->RunScript(m_ExecuteString,false,NULL,m_pEngine->m_pCurrentDocument);
	gbScrollToError=bSave;
	
}

void CBreakpointDialog::OnEvaluate() 
{
	bool bSave;


	bSave=gbScrollToError;
	gbScrollToError=false;
	UpdateData(true);
	VariantClear(m_pvarResult);
	m_pEngine->RunScript(m_ExecuteString,false,m_pvarResult,m_pEngine->m_pCurrentDocument);
	gbScrollToError=bSave;
}

BOOL CBreakpointDialog::OnInitDialog() 
{
	CDialog::OnInitDialog();

	//SetActiveWindow();
	SetOwner(m_pOwner);
	//SetParent(m_pOwner);
	SetParent(0);
	//ShowWindow(SW_SHOW);
	//SetForegroundWindow();
	SetWindowPos(&wndTop,0,0,0,0,SWP_NOMOVE|SWP_NOSIZE|SWP_SHOWWINDOW);
	if(gbLastRectValid)
		MoveWindow(&grectLast);
	m_EditBox.SetFocus();
	return false;
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}





void CBreakpointDialog::OnOK() 
{
	gbLastRectValid=true;
	GetWindowRect(&grectLast);
	CDialog::OnOK();
	
}
